/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2025 i-net software GmbH, Berlin, Germany.
**/
package sign;

import com.inet.report.Engine;
import com.inet.report.Fields;
import com.inet.report.PromptField;
import com.inet.report.certificate.CertificateInfoFactory;
import com.inet.report.certificate.CertificateInfo;

/**
 * This class is a sample implementation of the certificate info factory interface. The signature parameters in this
 * case has been put in prompt fields. Among others there are user name and user password. They can be used to read the
 * security settings. The other opportunity is to read security settings direct. This is illustrated in
 * <code>getCertificateInfo(Engine)</code>. The custom certificate info factory, if set, has a higher priority than the
 * default certificate info factory, that can be set through configuration.
 */
public class CustomCertificateInfoFactory implements CertificateInfoFactory {

    /**
     * {@inheritDoc}
     */
    @Override
    public CertificateInfo getCertificateInfo( Engine eng ) {
        // can be used for authentication
        String username = null;
        String userpassword = null;

        String keyStoreType = null;
        String keyStorePath = null;
        String keyStorePassword = null;
        String keyAlias = null;
        String keyPassword = null;
        String digestAlgorithmName = null;

        try {
            Fields fields = eng.getFields();
            int count = fields.getPromptFieldsCount();
            for( int i = 0; i < count; i++ ) {
                PromptField prompt = fields.getPromptField( i );
                String propKey = prompt.getName();
                if( "user".equals( propKey ) ) {
                    username = (String)prompt.getPromptValue();
                } else if( "password".equals( propKey ) ) {
                    userpassword = (String)prompt.getPromptValue();
                } else if( "keystoretype".equals( propKey ) ) {
                    keyStoreType = (String)prompt.getPromptValue();
                } else if( "keystorepath".equals( propKey ) ) {
                    keyStorePath = (String)prompt.getPromptValue();
                } else if( "keystorepassword".equals( propKey ) ) {
                    keyStorePassword = (String)prompt.getPromptValue();
                } else if( "keyalias".equals( propKey ) ) {
                    keyAlias = (String)prompt.getPromptValue();
                } else if( "keypassword".equals( propKey ) ) {
                    keyPassword = (String)prompt.getPromptValue();
                } else if( "digestalgorithmname".equals( propKey ) ) {
                    digestAlgorithmName = (String)prompt.getPromptValue();
                }
            }
            if( username != null && userpassword != null ) {
                // login and read the parameters
                // ( here is not used, because the parameters will be read direct from prompts)
            } else {
                if( keyStoreType != null && keyStorePath != null && keyStorePassword != null ) {
                    CertificateInfo info =
                        CertificateInfo.getInstance( keyStoreType, keyStorePath, keyStorePassword, keyAlias, keyPassword, digestAlgorithmName );
                    return info;
                }
            }
        } catch( Exception e ) {
            e.printStackTrace();
        }
        return null;
    }
}
